/*
 * Environment.hpp
 *
 *  Created on: 2009-11-05
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef ENVIRONMENT_HPP_
#define ENVIRONMENT_HPP_

#include <iostream>
#include <cstdlib>
#define __STDC_LIMIT_MACROS
#include <stdint.h>

/**
 * @brief Base class for all environments. All environments should derive from it.
 * This class cannot be abstract because of boost::python
 */
class Environment
{
public:
  Environment()
  {}

  virtual ~Environment()
  {}
  /**
   *@brief Gets the environment.
   * This is a dummy function, because there are no instances of this class.
   * @param n Number of chunk of the environment to get.
   * @param no Number of the current generation.
   * @param x X-coordinate of a lattice field to get the environment for.
   * @param y Y-coordinate of a lattice field to get the environment for.
   */
  virtual uint64_t getEnv(uint n, uint no, uint x, uint y) const
  {
    std::cerr << "wrong environment";
    return 0;
  };
  /**
   * @brief Gets a copy of current environment.
   */
  virtual Environment * clone() const {return new Environment(*this);}
};

/**
 * @brief An example of an environment working only for a part of the lattice
 */
class EnvSquare : public Environment
{
public:
  EnvSquare(uint n)
  {
    mod=n;
  }

  uint64_t getEnv(uint n, uint no, uint x, uint y) const
  {
    if (no%mod==0 && x>=20 && x<=80 && y>=20 && y<=80)
      return 0x9999999999999999ULL;
    else
      return 0xffffffffffffffffULL;
  }

  EnvSquare * clone() const
  {
    return new EnvSquare(*this);
  }

private:
  int mod;
};


class Red : public Environment
{
public:
  Red(uint n)
  {
    mod=n;
  }

  uint64_t getEnv(uint n, uint no, uint x, uint y) const
  {
    if (no%mod==0)
      return 0xffff00ffff00ffffULL;
    else
      return 0xffffffffffffffffULL;
  }

  Red * clone() const
  {
    return new Red(*this);
  }

private:
  int mod;
};


class Green : public Environment
{
public:
  Green(uint n)
  {
    mod=n;
  }

  uint64_t getEnv(uint n, uint no, uint x, uint y) const
  {
    if (no%mod==0)
      return 0x00ffff00ffff00ffULL;
    else
      return 0xffffffffffffffffULL;
  }

  Green * clone() const
  {
    return new Green(*this);
  }

private:
  int mod;
};


class Blue : public Environment
{
public:
  Blue(uint n)
  {
    mod=n;
  }

  uint64_t getEnv(uint n, uint no, uint x, uint y) const
  {
    if (no%mod==0)
      return  0xff00ffff00ffff00ULL;
    else
      return 0xffffffffffffffffULL;
  }

  Blue * clone() const
  {
    return new Blue(*this);
  }

private:
  int mod;
};


class Plain : public Environment
{
public:
  Plain()
  {
  }

  uint64_t getEnv(uint n, uint no, uint x, uint y) const
  {
    return 0xffffffffffffffffULL;
  }

  Plain * clone() const
  {
    return new Plain(*this);
  }
};

/*
class Random50 : public Environment
{
public:
  Random50(uint p)
  {
    evolutions=p;
    last=0;
  }

  void init(uint n)
  {
    N=n;
    env=new uint64_t[N];
    for (uint i=0; i<N; i++)
      env[i]=0xffffffffffffffffULL;
  }

  uint64_t getEnv(uint n, uint no, uint x, uint y) const
  {
    if (last!=no)
      {
        last=no;
        for (uint i=0; i<evolutions; i++)
          evolve();
      }

    if (n<N)
      return env[n];
    else
      return 0xffffffffffffffffULL;
  }

  Random50 * clone() const
  {
    return new Random50(*this);
  }

  void evolve()
  {
    env[rand()%N]^=(0x1ULL<<(rand()%64));
  }

private:
  uint64_t *env;
  uint evolutions,last;
};
*/

#endif /* ENVIRONMENT_HPP_ */
