/*
 * ImageProperties.cpp
 *
 *  Created on: 2009-11-11
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include "ImageProperties.hpp"

ImageProperties::ImageProperties()
{
  char hostname[30];
  gethostname((char*)hostname,30);
  setValue("hostname",std::string(hostname));

  //Defaults for pictures of chromosomes
  setValue("Cyfactor", 4);
  setValue("Cheight", 400);
  setValue("Cbgcolor", 0x000000);
  setValue("Cfgcolor", 0x00ffff);

  //for snapshots
  setValue("Scolor",std::vector<int>(1,0));
  setValue("Sbgcolor1", 0xff0000);
  setValue("Sbgcolor2", 0x0000ff);

  //for age
  setValue("Ayfactor", 4);
  setValue("Aheight", 400);
  setValue("Amales",0x0088ff);
  setValue("Afemales",0xff0000);

  //for HUD
  setValue("HUDbgcolor",0xaaaaff);
  setValue("HUDfgcolor",0xaaaaff);
  setValue("HUDfade",20);
}

ImageProperties::~ImageProperties()
{
}
