/*
 * ImageProperties.h
 *
 *  Created on: 2009-11-11
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef IMAGEPROPERTIES_H_
#define IMAGEPROPERTIES_H_
#include <string>
#include <vector>
#include <map>


class ImageProperties
{
public:
  ImageProperties();
  ~ImageProperties();

  void setValue(const std::string & key, int value)
  {
    paramsInt[key]=value;
  }

  void setValue(const std::string & key, const std::string & value)
  {
    paramsString[key]=value;
  }

  void setValue(const std::string & key, const std::vector<int> & v)
  {
    paramsVectInt[key]=v;
  }

  int getValueInt(const std::string & key) const
  {
    return paramsInt.find(key)->second;
  }

  const std::string & getValueString(const std::string & key) const
  {
    return paramsString.find(key)->second;
  }

  const std::vector<int> & getValueVectInt(const std::string & key) const
  {
    return paramsVectInt.find(key)->second;
  }

private:
  std::map<std::string,int> paramsInt;
  std::map<std::string,std::string> paramsString;
  std::map<std::string,std::vector<int> > paramsVectInt;
};

#endif /* IMAGEPROPERTIES_H_ */
