/*
 * ImgAge.hpp
 *
 *  Created on: 2009-12-15
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef IMGAGE_HPP_
#define IMGAGE_HPP_

#include <gd.h>
#include <gdfontg.h>
#include <vector>
#include "Image.hpp"
#include "../Lattice.hpp"

class ImgAge: public Image
{
public:
  ImgAge(const ImageProperties &p, const Lattice &l);
  void write(const std::string & filename) const;
  void write(const std::string & filename, bool f) const;
  void write(const std::string & filename, usint population) const;
  void write(const std::string & filename, usint population, bool f) const;
  void write(const std::string & filename, const std::vector<usint> & popNum) const;
  void write(const std::string & filename, const std::vector<usint> & popNum, bool f) const;

private:
  uint height;
  usint yfactor;
  uint gd_male, gd_female;
  const std::vector<int> color;
};

#endif /* IMGAGE_HPP_ */
