/*
 * imgChromosome.hpp
 *
 *  Created on: 2009-11-29
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef IMGCHROMOSOME_HPP_
#define IMGCHROMOSOME_HPP_

#include <gd.h>
#include <gdfontg.h>
#include <vector>
#include "Image.hpp"

class ImgChromosome: public Image
{
public:
  ImgChromosome(const ImageProperties &p, const Lattice &l);
  void write(const std::string & filename) const;
  void write(const std::string & filename, bool f) const;
  void write(const std::string & filename, usint population) const;
  void write(const std::string & filename, usint population, bool f) const;

private:
  void drawSingleChromosomeChart(gdImagePtr im, uint offset, usint chrNum, const Population * pop, bool f) const;
  void drawXChromosomeChart(gdImagePtr im, const uint offset, const Population * pop, bool f) const;
  void drawYChromosomeChart(gdImagePtr im, const uint offset, const Population * pop, bool f) const;
  void drawChart(gdImagePtr im, const uint offset, std::vector<uint> sum, uint max, uint factor) const;

private:
  uint height;
  usint yfactor;
  uint fgcolor, bgcolor;
  const std::vector<int> color;
};

#endif /* IMGCHROMOSOME_HPP_ */
