/*
 * ImgPopulSnapshot.hpp
 *
 *  Created on: 2009-12-30
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef IMGPOPULSNAPSHOT_HPP_
#define IMGPOPULSNAPSHOT_HPP_

#include <gd.h>
#include <gdfontg.h>
#include <vector>
#include <boost/lexical_cast.hpp>

#include "Image.hpp"

class ImgPopulSnapshot : public Image
{
public:
  ImgPopulSnapshot(const ImageProperties &p, const Lattice &l);
  void write(const std::string & filename) const;

private:
  uint populationToColor(const Specimen & s) const;
  void drawHUD(const gdImagePtr im, uint gen) const;
  void drawHUD1(const gdImagePtr im, uint gen) const;
  void drawHUD2(const gdImagePtr im, uint gen) const;

private:
  const std::vector<int> color;
  std::vector<std::string> karyotype;
  const std::string & hostname;
  uint bgcolor1,bgcolor2;
  uint factor;
  uint width, height;
};

#endif /* IMGPOPULSNAPSHOT_HPP_ */
