/*
 * ImagePng.cpp
 *
 *  Created on: 2009-11-11
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include <sstream>
#include <iomanip>
#include <boost/lexical_cast.hpp>

#include "../Lattice.hpp"
#include "ImageProperties.hpp"
#include "Image.hpp"
#include "ImgSnapshot.hpp"
#include "../Population.hpp"

//todo zmenic wszystko na korzystanie z lattice::width lattice::height

ImgSnapshot::ImgSnapshot(const ImageProperties &p, const Lattice &l):
  Image(p,l),
  color(p.getValueVectInt("Scolor")),
  hostname(p.getValueString("hostname"))
{
  const Tab &tab=l.getLattice();
  uint factorH=512/l.getHeight(); //if height < 512 then zoom in
  uint factorW=512/l.getWidth(); //if width < 512 then zoom in

  if (factorH==0)
    factorH=1; //no zoom out
  if (factorW==0)
    factorW=1;

  factor=(factorH>factorW)?factorH:factorW;

  if(factorH==1 || factorW==1)
    factor=1;

  width=tab.getWidth()*factor;
  height=tab.getHeight()*factor;


  bgcolor1=prop.getValueInt("Sbgcolor1");
  bgcolor2=prop.getValueInt("Sbgcolor2");
}

void ImgSnapshot::write(const std::string & fn) const
{
  write(fn, false);
}

void ImgSnapshot::write(const std::string & fn, bool f) const
{
  const Tab &tab=lat.getLattice();

  for (uint pict=0; pict<color.size(); pict++)
    {
      gdImagePtr im = gdImageCreateTrueColor(width,height);

      if (!f)
      {
        for (uint i=0; i<height; ++i)
	  for (uint j=0; j<width; ++j)
	    if (tab.isAlive(j/factor,i/factor))
	      im->tpixels[i][j]=haplotypeToColor(tab.get(j/factor,i/factor),color[pict]);
	    else
	      im->tpixels[i][j]=0xaaaaaa;
      }
      else
      {
        for (uint i=0; i<height; ++i)
          for (uint j=0; j<width; ++j)
            if (tab.isAlive(j/factor,i/factor) && tab.get(j/factor,i/factor).isFIVETed())
              im->tpixels[i][j]=haplotypeToColor(tab.get(j/factor,i/factor),color[pict]);
            else
              im->tpixels[i][j]=0xaaaaaa;
      }

      drawHUD(im,lat.getGennum());

      if (lat.getGennum()==0)
	{
	  drawHUD1(im,lat.getGennum());
	  drawHUD2(im,lat.getGennum());
	}

      const std::string filename=(color.size()==1)?fn+".png":(fn+"_"+boost::lexical_cast<std::string>(pict)+".png");
      FILE *pngout = fopen(filename.c_str(), "wb");
      gdImagePng(im, pngout);
      fclose(pngout);
      gdImageDestroy(im);
    }
}

uint ImgSnapshot::haplotypeToColor(const Specimen & s, uint chunk) const
{/*
  if (s.getGender()==MALE)
    return (s.getAge()<80)?0x00ffff:0x0000ff;
  else
    return (s.getAge()<80)?0xffff00:0xff0000;
  if (chunk>=s.getNumChunks())
  return 0xff0000;*/
  __uint64_t greater=(s.h1[chunk]>s.h2[chunk])?s.h1[chunk]:s.h2[chunk]; //kod leonarda da vinci
  greater>>=20;
  return (greater&0xffffff);
}

void ImgSnapshot::drawHUD(const gdImagePtr im, uint gen) const
{
  std::string number=boost::lexical_cast<std::string>(gen);
  int gd_white=gdImageColorAllocate(im,255,255,255);
  int gd_black=gdImageColorAllocate(im,0,0,0);
  gdFontPtr font = gdFontGetGiant();
  gdImageFilledRectangle(im,5,5,font->w*(number.length()+1),font->h+2,gd_black);
  gdImageString(im,font,8,3,(unsigned char*)number.c_str(),gd_white);
  gdImageColorDeallocate(im,gd_black);
  gdImageColorDeallocate(im,gd_white);
}

void ImgSnapshot::drawHUD1(const gdImagePtr im, uint gen) const
{
  int gd_white=gdImageColorAllocate(im,255,255,255);
  int bg2_color=gdImageColorAllocateAlpha(im,(bgcolor1&0xff0000)>>16 , (bgcolor1&0x00ff00)>>8 , bgcolor1&0x0000ff , 60);
  gdFontPtr font = gdFontGetGiant();

  std::vector<std::string> karyotype;

  karyotype.push_back("Parameters:");
  karyotype.push_back("Size: " + boost::lexical_cast<std::string>(width/factor) +"x"+boost::lexical_cast<std::string>(height/factor));
/*
  karyotype.push_back("Init: " + pop.initString);
  karyotype.push_back("Father dist.: " + boost::lexical_cast<std::string>(plane.getFatherDist()));
  karyotype.push_back("Child  dist.: " + boost::lexical_cast<std::string>(plane.getChildDist()));
  karyotype.push_back("Birth age: " + boost::lexical_cast<std::string>(plane.getBirthAge()));
  karyotype.push_back("Reproduction age: " + boost::lexical_cast<std::string>(plane.getReproductionAge()));
  karyotype.push_back("Life span: " + boost::lexical_cast<std::string>(plane.getLifeSpan()));
  karyotype.push_back("T: " + boost::lexical_cast<std::string>(plane.getT()));
  karyotype.push_back("B: " + boost::lexical_cast<std::string>(plane.getB()));
  karyotype.push_back("hostname: " + hostname);
  karyotype.push_back("panmictic: " + boost::lexical_cast<std::string>(plane.isPanmictic()));
*/
#ifdef NCHRVERSION
  karyotype.push_back("ver. "+std::string(NCHRVERSION));
#endif

  uint max_len=0;

  for (uint i=0; i<karyotype.size(); i++)
    if (max_len<karyotype[i].length())
      max_len=karyotype[i].length();

  const uint h=karyotype.size()*(font->h+2)+5,w=max_len*font->w+15;

  gdImageFilledRectangle(im,width-w,10,width-5,h+10,bg2_color);

  for (uint i=0; i<karyotype.size(); i++)
    gdImageString(im,font,width-w+5,10+i*(font->h+2),(unsigned char*)karyotype[i].c_str(),gd_white);

  gdImageColorDeallocate(im,gd_white);
  gdImageColorDeallocate(im,bg2_color);
}

void ImgSnapshot::drawHUD2(const gdImagePtr im, uint gen) const
{/*
  int gd_white=gdImageColorAllocate(im,255,255,255);
  int bg1_color=gdImageColorAllocateAlpha(im,(bgcolor2&0xff0000)>>16 , (bgcolor2&0x00ff00)>>8 , bgcolor2&0x0000ff , 60);
  gdFontPtr font = gdFontGetGiant();


  std::vector<std::string> karyotype;

  karyotype.push_back("Karyotype:");
  karyotype.push_back("  no  length     R      M");
  uint max_kario_len=karyotype.back().length();

  for (uint i=0; i<plane.getNumChromosomes(); i++)
    {
    std::stringstream s;
    if (plane.isSexChromosome() && i==uint(plane.getNumChromosomes()-1))
      s << std::setw(4) << "X/Y";
    else
      s << std::setw(4) << i+1;
    s << std::setw(8) << plane.getChromLength(i)*64;
    s << std::setw(5) << int(plane.getRecombRate()[i]*100)/100 << '.' << std::setw(2) << std::setfill('0') <<  (int(plane.getRecombRate()[i]*100)%100) << std::setfill(' ');
    s << std::setw(4) << int(plane.getMutationRate()[i]*100)/100 << '.' << std::setw(2) << std::setfill('0') << (int(plane.getMutationRate()[i]*100)%100) << "  ";

    karyotype.push_back(s.str());

    if (max_kario_len<karyotype.back().length())
      max_kario_len=karyotype.back().length();
    }

  const uint top=height-karyotype.size()*(font->h+2)-5,right=max_kario_len*font->w+10;

  gdImageFilledRectangle(im,5,top,right,height-5,bg1_color);

  for (uint i=0; i<karyotype.size(); i++)
    gdImageString(im,font,10,top+i*(font->h+2),(unsigned char*)karyotype[i].c_str(),gd_white);

  gdImageColorDeallocate(im,gd_white);
  gdImageColorDeallocate(im,bg1_color);*/
}

