/*
 * ImagePng.h
 *
 *  Created on: 2009-11-11
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef IMAGEPNG_H_
#define IMAGEPNG_H_

#include <gd.h>
#include <gdfontg.h>
#include <vector>
#include <boost/lexical_cast.hpp>

#include "Image.hpp"

class ImgSnapshot : public Image
{
public:
  ImgSnapshot(const ImageProperties &p, const Lattice &l);
  void write(const std::string & filename) const;
  void write(const std::string & filename, bool f) const;

private:
  uint haplotypeToColor(const Specimen & s, uint chunk) const;
  void drawHUD(const gdImagePtr im, uint gen) const;
  void drawHUD1(const gdImagePtr im, uint gen) const;
  void drawHUD2(const gdImagePtr im, uint gen) const;

private:
  const std::vector<int> color;
  std::vector<std::string> karyotype;
  const std::string & hostname;
  uint bgcolor1,bgcolor2;
  uint factor;
  uint width, height;
};

#endif /* IMAGEPNG_H_ */
