/*
 * Content.cpp
 *
 *  Created on: 2010-09-25
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include "Content.hpp"

void Content::write(std::string filename)
{
  std::ofstream of(filename.c_str());

  write_preamble(of);
  write_tables(of);  ;
  write_ending(of);
}

void Content::write_preamble(std::ofstream &of)
{
  of << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
  of << "<office:document-content xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\""
    " xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" xmlns:text=\"urn:oasis:names:"
    "tc:opendocument:xmlns:text:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0"
    "\" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\" xmlns:fo=\"urn:oasis:names"
    ":tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xm"
    "lns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns"
    ":meta:1.0\" xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\" xmlns:present"
    "ation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\" xmlns:svg=\"urn:oasis:names:t"
    "c:opendocument:xmlns:svg-compatible:1.0\" xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:"
    "chart:1.0\" xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\" xmlns:math=\"http://"
    "www.w3.org/1998/Math/MathML\" xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\" xm"
    "lns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\" xmlns:ooo=\"http://openoffice."
    "org/2004/office\" xmlns:ooow=\"http://openoffice.org/2004/writer\" xmlns:oooc=\"http://openoff"
    "ice.org/2004/calc\" xmlns:dom=\"http://www.w3.org/2001/xml-events\" xmlns:xforms=\"http://www."
    "w3.org/2002/xforms\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3."
    "org/2001/XMLSchema-instance\" xmlns:rpt=\"http://openoffice.org/2005/report\" xmlns:of=\"urn:o"
    "asis:names:tc:opendocument:xmlns:of:1.2\" xmlns:rdfa=\"http://docs.oasis-open.org/opendocument"
    "/meta/rdfa#\" xmlns:field=\"urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0\""
    " xmlns:formx=\"urn:openoffice:names:experimental:ooxml-odf-interop:xmlns:form:1.0\" office:ver"
    "sion=\"1.2\"><office:scripts/><office:font-face-decls><style:font-face style:name=\"Arial\" sv"
    "g:font-family=\"Arial\" style:font-family-generic=\"swiss\" style:font-pitch=\"variable\"/><st"
    "yle:font-face style:name=\"DejaVu Sans\" svg:font-family=\"&apos;DejaVu Sans&apos;\" style:fon"
    "t-family-generic=\"system\" style:font-pitch=\"variable\"/></office:font-face-decls>";
  of << "<office:automatic-styles>";

  of << "<style:style style:name=\"co1\" style:family=\"table-column\"><style:table-column-properties fo:break-before=\"auto\" style:column-width=\"1.3cm\"/></style:style>";
  of << "<style:style style:name=\"co2\" style:family=\"table-column\"><style:table-column-properties fo:break-before=\"auto\" style:column-width=\"1.9cm\"/></style:style>";
  of << "<style:style style:name=\"co3\" style:family=\"table-column\"><style:table-column-properties fo:break-before=\"auto\" style:column-width=\"1.7cm\"/></style:style>";
  of << "<style:style style:name=\"co10\" style:family=\"table-column\"><style:table-column-properties fo:break-before=\"auto\" style:column-width=\"2.3cm\"/></style:style>";

  of << "<style:style style:name=\"ro1\" style:family=\"table-row\"><style:table-row-properties style:ro"
    "w-height=\"0.448cm\" fo:break-before=\"auto\" style:use-optimal-row-height=\"true\"/></style:style><s"
    "tyle:style style:name=\"ta1\" style:family=\"table\" style:master-page-name=\"Default\"><style:table-"
    "properties table:display=\"true\" style:writing-mode=\"lr-tb\"/></style:style><number:percentage-st"
    "yle style:name=\"N10\"><number:number number:decimal-places=\"0\" number:min-integer-digits=\"1\"/><n"
    "umber:text>%</number:text></number:percentage-style>";

  of << "<style:style style:name=\"ce1\" style:family=\"table-cell\" style:parent-style-name=\"Default\"><"
    "style:table-cell-properties fo:background-color=\"#ff0000\" style:text-align-source=\"fix\" style:rep"
    "eat-content=\"false\"/><style:paragraph-properties fo:text-align=\"center\" fo:margin-left=\"0cm\"/><"
    "style:text-properties style:use-window-font-color=\"true\"/></style:style><style:style style:name=\"c"
    "e2\" style:family=\"table-cell\" style:parent-style-name=\"Default\"><style:table-cell-properties fo:"
    "border=\"none\"/></style:style><style:style style:name=\"ce3\" style:family=\"table-cell\" style:pare"
    "nt-style-name=\"Default\"><style:table-cell-properties fo:background-color=\"#006b6b\"/><style:text-p"
    "roperties fo:color=\"#ffffff\"/></style:style><style:style style:name=\"ce4\" style:family=\"table-ce"
    "ll\" style:parent-style-name=\"Default\"><style:table-cell-properties style:text-align-source=\"value"
    "-type\" style:repeat-content=\"false\"/><style:paragraph-properties fo:margin-left=\"0cm\"/></style:s"
    "tyle><style:style style:name=\"ce5\" style:family=\"table-cell\" style:parent-style-name=\"Default\">"
    "<style:table-cell-properties fo:background-color=\"#006b6b\" style:text-align-source=\"fix\" style:re"
    "peat-content=\"false\"/><style:paragraph-properties fo:text-align=\"start\" fo:margin-left=\"0cm\"/><"
    "style:text-properties fo:color=\"#ffffff\"/></style:style><style:style style:name=\"ce6\" style:famil"
    "y=\"table-cell\" style:parent-style-name=\"Default\" style:data-style-name=\"N10\"><style:table-cell-"
    "properties fo:border=\"none\"/></style:style><style:style style:name=\"ce7\" style:family=\"table-cel"
    "l\" style:parent-style-name=\"Default\" style:data-style-name=\"N10\"><style:table-cell-properties fo"
    ":background-color=\"#006b6b\"/><style:text-properties fo:color=\"#ffffff\"/></style:style><style:styl"
    "e style:name=\"ce8\" style:family=\"table-cell\" style:parent-style-name=\"Default\" style:data-style"
    "-name=\"N10\"><style:table-cell-properties style:text-align-source=\"fix\" style:repeat-content=\"fal"
    "se\"/><style:paragraph-properties fo:text-align=\"center\" fo:margin-left=\"0cm\"/></style:style><sty"
    "le:style style:name=\"ce9\" style:family=\"table-cell\" style:parent-style-name=\"Default\" style:dat"
    "a-style-name=\"N10\"/><style:style style:name=\"ce10\" style:family=\"table-cell\" style:parent-style"
    "-name=\"Default\"><style:table-cell-properties fo:background-color=\"#0000ff\"/><style:text-propertie"
    "s fo:color=\"#ffffff\"/></style:style><style:style style:name=\"ce11\" style:family=\"table-cell\" st"
    "yle:parent-style-name=\"Default\"><style:table-cell-properties fo:background-color=\"#0000ff\" style:"
    "text-align-source=\"fix\" style:repeat-content=\"false\"/><style:paragraph-properties fo:text-align=\""
    "start\" fo:margin-left=\"0cm\"/><style:text-properties fo:color=\"#ffffff\"/></style:style><style:sty"
    "le style:name=\"ce12\" style:family=\"table-cell\" style:parent-style-name=\"Default\" style:data-sty"
    "le-name=\"N10\"><style:table-cell-properties fo:background-color=\"#0000ff\"/><style:text-properties "
    "fo:color=\"#ffffff\"/></style:style><style:style style:name=\"ce13\" style:family=\"table-cell\" styl"
    "e:parent-style-name=\"Default\"><style:table-cell-properties fo:background-color=\"#2300dc\" style:te"
    "xt-align-source=\"fix\" style:repeat-content=\"false\"/><style:paragraph-properties fo:text-align=\"e"
    "nd\" fo:margin-left=\"0cm\"/><style:text-properties fo:color=\"#ffffff\"/></style:style><style:style "
    "style:name=\"ce14\" style:family=\"table-cell\" style:parent-style-name=\"Default\"><style:table-cell"
    "-properties style:text-align-source=\"fix\" style:repeat-content=\"false\"/><style:paragraph-properti"
    "es fo:text-align=\"center\" fo:margin-left=\"0cm\"/></style:style><style:style style:name=\"ce15\" st"
    "yle:family=\"table-cell\" style:parent-style-name=\"Default\"><style:table-cell-properties fo:backgro"
    "und-color=\"#b84747\" style:text-align-source=\"fix\" style:repeat-content=\"false\"/><style:paragrap"
    "h-properties fo:text-align=\"end\" fo:margin-left=\"0cm\"/><style:text-properties fo:color=\"#ffffff\"/>"
    "</style:style><style:style style:name=\"ce16\" style:family=\"table-cell\" style:parent-style-name=\"D"
    "efault\"><style:table-cell-properties fo:background-color=\"#ff00ff\" style:text-align-source=\"fix\""
    " style:repeat-content=\"false\"/><style:paragraph-properties fo:text-align=\"end\" fo:margin-left=\"0"
    "cm\"/><style:text-properties fo:color=\"#ffffff\"/></style:style><style:style style:name=\"ce17\" sty"
    "le:family=\"table-cell\" style:parent-style-name=\"Default\"><style:table-cell-properties fo:backgrou"
    "nd-color=\"#ff00ff\"/><style:text-properties fo:color=\"#ffffff\"/></style:style><style:style style:n"
    "ame=\"ta_extref\" style:family=\"table\"><style:table-properties table:display=\"false\"/></style:sty"
    "le></office:automatic-styles>";
}


void Content::write_tables(std::ofstream &of)
{
  of << "<office:body><office:spreadsheet>";
  for (usint i=0; i<lat.atab.size(); i++)
    {
      const Atab & atab=lat.atab[i];
      const Population & p=*atab.getPopulation();

      uint num_chr=p.getNumChromosomes();
      bool has_y=p.hasYchr();

      of << "<table:table table:name=\"Pop " << p.getName() << "\" table:style-name=\"ta1\" table:print=\"false\">";
      of << "<table:table-column table:style-name=\"co2\" table:default-cell-style-name=\"Default\"/>";

      for (uint j=0; j<num_chr; j++)
	of << "<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>"
	  "<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>"
	  "<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"ce9\"/>"
	  "<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"ce9\"/>"
	  "<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"ce9\"/>";

      of << "<table:table-column table:style-name=\"co10\" table:default-cell-style-name=\"Default\"/>";

      of << "<table:table-column table:style-name=\"co1\" table:default-cell-style-name=\"Default\"/>"
	"<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>"
	"<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>"
	"<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>";

      of << "<table:table-column table:style-name=\"co10\" table:default-cell-style-name=\"Default\"/>";

      of << "<table:table-column table:style-name=\"co10\" table:default-cell-style-name=\"Default\"/>"
	"<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>";

      of << "<table:table-column table:style-name=\"co10\" table:default-cell-style-name=\"Default\"/>"
	"<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>";

      of << "<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>"
	"<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>"
        "<table:table-column table:style-name=\"co3\" table:default-cell-style-name=\"Default\"/>";

      of << "<table:table-row table:style-name=\"ro1\"><table:table-cell/><table:table-cell table:numbe"
	"r-columns-repeated=\""<<6+num_chr*5<<"\"/><table:table-cell office:value-type=\"string\"><text"
        ":p>*) per female in RA</text:p></table:table-cell><table:table-cell table:number-columns-repea"
        "ted=\"3\"/><table:table-cell office:value-type=\"string\"><text:p>infertile</text:p></table:ta"
        "ble-cell></table:table-row>";

      of << "<table:table-row table:style-name=\"ro1\"><table:table-cell table:style-name=\"ce1\" office"
	":value-type=\"string\"><text:p>gen</text:p></table:table-cell>";

      for (uint j=0; j<num_chr; j++)
	if (j%2)
	  of << "<table:table-cell table:style-name=\"ce3\"/><table:table-cell table:style-name=\"ce5\" offi"
	    "ce:value-type=\"string\"><text:p>Chromosome "<<(j+1)<< ((has_y && j==num_chr-1)?" X/Y":"") <<
	    "</text:p></table:table-cel"
	    "l><table:table-cell table:style-name=\"ce7\" table:number-columns-repeated=\"3\"/>";
	else
	  of << "<table:table-cell table:style-name=\"ce10\"/><table:table-cell table:style-name=\"ce11\" of"
	    "fice:value-type=\"string\"><text:p>Chromosome "<<(j+1)<< ((has_y && j==num_chr-1)?" X/Y":"") <<
	    "</text:p></table:table-c"
	    "ell><table:table-cell table:style-name=\"ce12\" table:number-columns-repeated=\"3\"/>";

      of << "<table:table-cell/><table:table-cell table:style-name=\"ce13\" office:value-type=\"string\">"
	"<text:p>Males</text:p></table:table-cell><table:table-cell table:style-name=\"ce13\"/><table:tab"
	"le-cell table:style-name=\"ce15\" office:value-type=\"string\"><text:p>Females</text:p></table:t"
	"able-cell><table:table-cell table:style-name=\"ce15\"/><table:table-cell/><table:table-cell tabl"
	"e:style-name=\"ce16\" office:value-type=\"string\"><text:p>Newborns</text:p></table:table-cell><"
	"table:table-cell table:style-name=\"ce17\"/><table:table-cell/><table:table-cell table:style-nam"
        "e=\"ce13\" office:value-type=\"string\"><text:p>Males</text:p></table:table-cell><table:table-ce"
        "ll table:style-name=\"ce13\"/><table:table-cell table:style-name=\"ce15\" office:value-type=\"st"
        "ring\"><text:p>Females</text:p></table:table-cell><table:table-cell table:style-name=\"ce15\"/><"
        "/table:table-row>";


      of <<"<table:table-row table:style-name=\"ro1\"><table:table-cell/>";

      for (uint j=0; j<num_chr; j++)
	of << "<table:table-cell table:style-name=\"ce4\" office:value-type=\"string\"><text:p>Kill &lt; "
	  "RA</text:p></table:table-cell><table:table-cell table:style-name=\"ce4\" office:value-type=\"s"
	  "tring\"><text:p>Kill &gt; BA &lt; RA</text:p></table:table-cell><table:table-cell table:style-"
          "name=\"ce8\" office:value-type=\"string\"><text:p>kill &gt; RA</text:p></table:table-cell><tab"
          "le:table-cell table:style-name=\"ce8\" office:value-type=\"string\"><text:p>0..BA</text:p></ta"
          "ble:table-cell><table:table-cell table:style-name=\"ce8\" office:value-type=\"string\"><text:p"
          ">BA..RA</text:p></table:table-cell>";

      of <<"<table:table-cell/>";

      of << "<table:table-cell table:style-name=\"ce14\" office:value-type=\"string\"><text:p>BA..RA</text"
	":p></table:table-cell><table:table-cell table:style-name=\"ce14\" office:value-type=\"string\"><t"
	"ext:p>RA..END</text:p></table:table-cell><table:table-cell table:style-name=\"ce14\" office:value"
	"-type=\"string\"><text:p>BA..RA</text:p></table:table-cell><table:table-cell table:style-name=\"c"
	"e14\" office:value-type=\"string\"><text:p>RA..END</text:p></table:table-cell><table:table-cell/>"
	"<table:table-cell table:style-name=\"ce14\" office:value-type=\"string\"><text:p>#conceptions</te"
	"xt:p></table:table-cell><table:table-cell table:style-name=\"ce14\" office:value-type=\"string\">"
	"<text:p>#babies</text:p></table:table-cell><table:table-cell/>"
        "<table:table-cell table:style-name=\"ce14\" office:value-type=\"string\"><text:p>BA..RA</text"
	":p></table:table-cell><table:table-cell table:style-name=\"ce14\" office:value-type=\"string\"><t"
	"ext:p>RA..END</text:p></table:table-cell><table:table-cell table:style-name=\"ce14\" office:value"
	"-type=\"string\"><text:p>BA..RA</text:p></table:table-cell><table:table-cell table:style-name=\"c"
	"e14\" office:value-type=\"string\"><text:p>RA..END</text:p></table:table-cell></table:table-row>";

      write_data(of,atab);

      of << "</table:table>";
    }
}

void Content::write_data(std::ofstream & of, const Atab & atab)
{
  const PopStatistics & data=atab.getPopStats();
  const PopStatistics::Data2d & d2d=data.getData();
  const PopStatistics::Gen & gennum=data.getGennum();
  const PopStatistics::General & dnc=data.getNonChrData();
  const uint size=data.size();
  if (size==0)
    return;

  const uint generations=(size>1)?(gennum[size-1]-gennum[size-2]):gennum[0];

  for (uint j=0; j<size; j++)
    {
      of << "<table:table-row table:style-name=\"ro1\">";
      write_datacell(of,uint64_t(gennum[j]));
      for (uint i=0; i<data.getNumChromosomes(); i++)
	{
	  write_datacell(of,d2d[i][j].killingBeforeBA);
	  write_datacell(of,d2d[i][j].killingBAtoRA);
	  write_datacell(of,d2d[i][j].killingAfterRA);

	  write_datacellPerCent(of,d2d[i][j].fractionBA);
	  write_datacellPerCent(of,d2d[i][j].fractionBARA);
	}
      write_datacell(of);

      write_datacell(of,(uint64_t)dnc[j].num_males_BARA);
      write_datacell(of,(uint64_t)dnc[j].num_males_RA);
      write_datacell(of,(uint64_t)dnc[j].num_females_BARA);
      write_datacell(of,(uint64_t)dnc[j].num_females_RA);

      write_datacell(of);

      write_datacell(of,((dnc[j].conceptions/float(generations))/float(dnc[j].num_females_RA)));
      write_datacell(of,((dnc[j].babies/float(generations))/float(dnc[j].num_females_RA)));

      write_datacell(of);

      write_datacell(of,dnc[j].infertile_num_males_BARA/float(dnc[j].num_males_BARA));
      write_datacell(of,dnc[j].infertile_num_males_RA/float(dnc[j].num_males_RA));
      write_datacell(of,dnc[j].infertile_num_females_BARA/float(dnc[j].num_females_BARA));
      write_datacell(of,dnc[j].infertile_num_females_RA/float(dnc[j].num_females_RA));

      of << "</table:table-row>";
    }
}

void Content::write_datacell(std::ofstream & of, uint64_t value)
{
  of << "<table:table-cell office:value-type=\"float\" office:value=\"" << value << "\"><text:p>"
     << value << "</text:p></table:table-cell>";
}

void Content::write_datacell(std::ofstream & of, float value)
{
  of << "<table:table-cell office:value-type=\"float\" office:value=\"" << value << "\"><text:p>"
     << value << "</text:p></table:table-cell>";
}

void Content::write_datacellPerCent(std::ofstream & of, float value)
{
  of << "<table:table-cell office:value-type=\"percentage\" office:value=\"" << value << "\"><text:p>"
     << uint(value*100) << "%</text:p></table:table-cell>";
}

void Content::write_datacell(std::ofstream & of)
{
  of << "<table:table-cell/>";
}

void Content::write_ending(std::ofstream &of)
{
  of << "</office:spreadsheet></office:body></office:document-content>";
}


