/*
 * Content.hpp
 *
 *  Created on: 2010-09-25
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef CONTENT_HPP_
#define CONTENT_HPP_

#include <fstream>
#include "../detail/defs.hpp"
#include "../detail/PopStatistics.hpp"
#include "../Lattice.hpp"

class Content
{
public:
  Content(const Lattice &l):num_gen(100),lat(l) //TODO: magic values
  {

  }

  void write(std::string filename);

private:
  void write_preamble(std::ofstream &of);
  void write_tables(std::ofstream &of);
  void write_data(std::ofstream &of, const Atab & atab);
  void write_ending(std::ofstream &of);

  void write_datacell(std::ofstream & of, uint64_t value);
  void write_datacell(std::ofstream & of, float value);
  void write_datacellPerCent(std::ofstream & of, float value);
  void write_datacell(std::ofstream & of);

private:
  uint num_gen;
  const Lattice & lat;
};

#endif /* CONTENT_HPP_ */
