/*
 * PopCNT.cpp
 *
 *  Created on: 2010-01-03
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include <fstream>
#include "PopCNT.hpp"

void PopCNT::write(const std::string & filename) const
{
  write (filename, false);
}

void PopCNT::write(const std::string & filename, bool f) const
{
  if (!f)
  {
    bool writeheader=false;
    std::ifstream inp((filename+".txt").c_str(),std::ifstream::in);
    inp.close();
    if(inp.fail())
    {
    inp.clear(std::ios::failbit);
    writeheader=true;
    }

  std::ofstream out((filename+".txt").c_str(),std::ios::app);
  if(writeheader)
    {
    out << "#num\t";
    for (usint i=0; i<lat.atab.size(); i++)
      out << lat.getPopName(i) << '\t';
    out << std::endl;
    }
  out << lat.getGennum() << '\t';
  for (usint i=0; i<lat.atab.size(); i++)
      out << lat.atabCount(i, f) << '\t';
  out << std::endl;
  }
  else
  {
    bool writeheader=false;
    std::ifstream inp((filename+"f.txt").c_str(),std::ifstream::in);
    inp.close();
    if(inp.fail())
    {
    inp.clear(std::ios::failbit);
    writeheader=true;
    }

  std::ofstream out((filename+"f.txt").c_str(),std::ios::app);
  if(writeheader)
    {
    out << "#num\t";
    for (usint i=0; i<lat.atab.size(); i++)
      out << lat.getPopName(i) << '\t';
    out << std::endl;
    }
  out << lat.getGennum() << '\t';
  for (usint i=0; i<lat.atab.size(); i++)
      out << lat.atabCount(i, f) << '\t';
  out << std::endl;
  }
}
