/*
 * TxtAge.cpp
 *
 *  Created on: 2009-12-18
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include <fstream>
#include "TxtAge.hpp"

void TxtAge::write(const std::string & filename) const
{
  std::vector <usint> pop;
  for (usint i=0; i<lat.atab.size(); i++)
    pop.push_back(i);
  write(filename,pop);
}

void TxtAge::write(const std::string & filename, usint population) const
{
  std::vector <usint> pop(1,population);
  write(filename,pop);
}


void TxtAge::write(const std::string & filename, const std::vector<usint> & popNum) const
{
  std::ofstream out((filename+".txt").c_str());

  const uint life_span=lat.atab[popNum[0]].getPopulation()->getLifeSpan();

  std::vector<uint> tabM(life_span,0);
  std::vector<uint> tabF(life_span,0);
  std::vector<uint> tabIM(life_span,0);
  std::vector<uint> tabIF(life_span,0);
  std::vector<uint> tabFM(life_span,0);
  std::vector<uint> tabFF(life_span,0);

  for (std::vector<usint>::const_iterator it=popNum.begin(); it!=popNum.end(); ++it)
    {
      const Atab &atab=lat.atab[*it];

      if (atab.getPopulation()->getLifeSpan()!=life_span)
        throw std::runtime_error("TxtAge: You have to select populations with the same life spans for cumulative data.");

      for (uint i=0; i<life_span; i++)
        {
          tabM[i]+=atab.getAtabInd(i,MALE);
          tabF[i]+=atab.getAtabInd(i,FEMALE);
          tabIM[i]+=atab.getAtabInd(i,INF_MALE);
          tabIF[i]+=atab.getAtabInd(i,INF_FEMALE);
	  tabFM[i]+=atab.getAtabInd(i,FIVETed_MALE);
          tabFF[i]+=atab.getAtabInd(i,FIVETed_FEMALE);
        }
    }

  out << "#M\tF\tInf.M\tInf.F\tivM\tivF" << std::endl;

  for (uint i=0; i<life_span; i++)
    out << tabM[i] << '\t' << tabF[i] << '\t' << tabIM[i] << '\t' << tabIF[i] << '\t' << tabFM[i] << '\t' << tabFF[i]<< std::endl;
}

