/*
 * TxtChrStat.cpp
 *
 *  Created on: 2010-09-21
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include <fstream>
#include "TxtChrStat.hpp"

void TxtChrStat::write(const std::string & filename) const
{
  std::vector <usint> pop;
  for (usint i=0; i<lat.atab.size(); i++)
    pop.push_back(i);
  write(filename,pop);
}

void TxtChrStat::write(const std::string & filename, usint population) const
{
  std::vector <usint> pop(1,population);
  write(filename,pop);
}


void TxtChrStat::write(const std::string & filename, const std::vector<usint> & popNum) const
{
  std::ofstream out((filename+".txt").c_str(),std::ios::app);

  const uint life_span=lat.atab[popNum[0]].getPopulation()->getLifeSpan();
  const uint num_chrom=lat.atab[popNum[0]].getPopulation()->getNumChromosomes();

  std::vector<uint> sums(num_chrom,0);

  for (std::vector<usint>::const_iterator it=popNum.begin(); it!=popNum.end(); ++it)
    {
      const Atab &atab=lat.atab[*it];

      if (atab.getPopulation()->getLifeSpan()!=life_span)
        throw std::runtime_error("TxtChrStat: You have to select populations with the same life spans for cumulative data.");

      if (atab.getPopulation()->getNumChromosomes()!=num_chrom)
        throw std::runtime_error("TxtChrStat: You have to select populations with the same number of chromosomes.");


      //const PopStatistics::Data2d &d=atab.getPopStats();
      //for (uint i=0; i<d.size(); i++)
        //sums[i]+=d[i];
    }

  out << std::endl;
  for (uint i=0; i<num_chrom; i++)
    out << sums[i] << ' ';
}



