/*
 * TxtChromosome.cpp
 *
 *  Created on: 2010-01-22
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include "TxtChromosome.hpp"


TxtChromosome::TxtChromosome(const Lattice &l):Text(l)
{

}

void TxtChromosome::write(const std::string & filename) const
{
  write (filename, 0, false);
}

void TxtChromosome::write(const std::string & filename, bool f) const
{
  write (filename, 0, f);
}

void TxtChromosome::write(const std::string & filename, usint population) const
{
  write (filename, population, false);
}

void TxtChromosome::write(const std::string & filename, usint population, bool f) const
{
  std::ofstream out((filename+".txt").c_str());

  const Population *pop=lat.atab[population].getPopulation().get();

  for (uint i=0; i<lat.atab.size(); i++)
    if (!pop->sameLayout(lat.atab.at(i).getPopulation().get()))
      throw std::runtime_error("If you want collective chromosome chart, all populations must have the same layout and genome length.");

  uint nc=pop->getNumChunks();
  if (pop->hasYchr())
    nc+=pop->getChromLength(pop->getNumChromosomes()-1);

  uint offset=0;
  for (usint i=0; i<pop->getNumChromosomes()-1; i++)
    {
      drawSingleChromosomeChart(out,offset,i,pop,f);
      offset+=pop->getChromLength(i)*64;
    }

  if (!pop->hasYchr())
    {
      const uint i=pop->getNumChromosomes()-1;
      drawSingleChromosomeChart(out,offset,i,pop,f);
    } else
    {
      drawXChromosomeChart(out,offset,pop,f);
      offset+=pop->getChromLength(pop->getNumChromosomes()-1)*64;
      drawYChromosomeChart(out,offset,pop,f);
    }
}

void TxtChromosome::drawSingleChromosomeChart(std::ofstream & out, uint offset, usint chrNum, const Population * pop, bool f) const
{
  const uint width=pop->getChromLength(chrNum)*64;

  const Tab &tab=lat.getLattice();
  std::vector<uint> sum(width,0);

  const uint chr_offset=pop->getChromOffset(chrNum);
  uint count=0;

  if (!f)
  {
    for (uint i=0; i<tab.getHeight(); ++i)
      for (uint j=0; j<tab.getWidth(); ++j)
        if (tab.isAlive(j,i) && (lat.getPopulation(tab.get(j,i).getPop()).get()==pop))
          {
	    count+=2;
	    for (uint k=0; k<pop->getChromLength(chrNum); k++)
	      for (int y=0; y<64; y++)
	        {
		  if ((1ULL<<(63-y))&(tab.get(j,i).h1[k+chr_offset]))
		    sum[y+64*k]++;
		  if ((1ULL<<(63-y))&(tab.get(j,i).h2[k+chr_offset]))
		    sum[y+64*k]++;
	        }
          }
  }
  else
  {
    for (uint i=0; i<tab.getHeight(); ++i)
      for (uint j=0; j<tab.getWidth(); ++j)
        if (tab.isAlive(j,i) && (lat.getPopulation(tab.get(j,i).getPop()).get()==pop) && tab.get(j,i).isFIVETed())
          {
            count+=2;
            for (uint k=0; k<pop->getChromLength(chrNum); k++)
              for (int y=0; y<64; y++)
                {
                  if ((1ULL<<(63-y))&(tab.get(j,i).h1[k+chr_offset]))
                    sum[y+64*k]++;
                  if ((1ULL<<(63-y))&(tab.get(j,i).h2[k+chr_offset]))
                    sum[y+64*k]++;
                }
          }
  }

  drawChart(out,sum);
}

void TxtChromosome::drawXChromosomeChart(std::ofstream & out, uint offset, const Population * pop, bool f) const
{
  const int chr=pop->getNumChromosomes()-1;
  const uint width=pop->getChromLength(chr)*64;

  const Tab &tab=lat.getLattice();
  std::vector<uint> sum(width,0);

  const uint chr_offset=pop->getChromOffset(chr);

  if (!f)
  {
    for (uint i=0; i<tab.getHeight(); ++i)
      for (uint j=0; j<tab.getWidth(); ++j)
        if (tab.isAlive(j,i) && (lat.getPopulation(tab.get(j,i).getPop()).get()==pop))
          {
	    if(tab.get(j,i).getGender()==FEMALE)
	      {//2 chromosomes for FEMALES
	        for (uint k=0; k<pop->getChromLength(chr); k++)
		  for (int y=0; y<64; y++)
		    {
		      if ((1ULL<<(63-y))&(tab.get(j,i).h1[k+chr_offset]))
		        sum[y+64*k]++;
		      if ((1ULL<<(63-y))&(tab.get(j,i).h2[k+chr_offset]))
		        sum[y+64*k]++;
		    }
	      } else
              {//1 chromosome for MALES
	        for (uint k=0; k<pop->getChromLength(chr); k++)
		  for (int y=0; y<64; y++)
		    {
		      if (!tab.get(j,i).getY())
		        {
			  if ((1ULL<<(63-y))&(tab.get(j,i).h2[k+chr_offset]))
			    sum[y+64*k]++;
		        }
		      else
		        {
			  if ((1ULL<<(63-y))&(tab.get(j,i).h1[k+chr_offset]))
			    sum[y+64*k]++;
		        }
		    }
              }
          }
  }
  else
  {
    for (uint i=0; i<tab.getHeight(); ++i)
      for (uint j=0; j<tab.getWidth(); ++j)
        if (tab.isAlive(j,i) && (lat.getPopulation(tab.get(j,i).getPop()).get()==pop) && tab.get(j,i).isFIVETed())
          {
            if(tab.get(j,i).getGender()==FEMALE)
              {//2 chromosomes for FEMALES
                for (uint k=0; k<pop->getChromLength(chr); k++)
                  for (int y=0; y<64; y++)
                    {
                      if ((1ULL<<(63-y))&(tab.get(j,i).h1[k+chr_offset]))
                        sum[y+64*k]++;
                      if ((1ULL<<(63-y))&(tab.get(j,i).h2[k+chr_offset]))
                        sum[y+64*k]++;
                    }
              } else
              {//1 chromosome for MALES
                for (uint k=0; k<pop->getChromLength(chr); k++)
                  for (int y=0; y<64; y++)
                    {
                      if (!tab.get(j,i).getY())
                        {
                          if ((1ULL<<(63-y))&(tab.get(j,i).h2[k+chr_offset]))
                            sum[y+64*k]++;
                        }
                      else
                        {
                          if ((1ULL<<(63-y))&(tab.get(j,i).h1[k+chr_offset]))
                            sum[y+64*k]++;
                        }
                    }
              }
          }
  }  

  drawChart(out,sum);
}

void TxtChromosome::drawYChromosomeChart(std::ofstream & out, uint offset, const Population * pop, bool f) const
{
  const int chr=pop->getNumChromosomes()-1;
  const uint width=pop->getChromLength(chr)*64;

  const Tab &tab=lat.getLattice();
  std::vector<uint> sum(width,0);

  const uint chr_offset=pop->getChromOffset(chr);
  if (!f)
  {
    for (uint i=0; i<tab.getHeight(); ++i)
      for (uint j=0; j<tab.getWidth(); ++j)
        if (tab.isAlive(j,i) && (lat.getPopulation(tab.get(j,i).getPop()).get()==pop) && tab.get(j,i).getGender()==MALE)
          {
            for (uint k=0; k<pop->getChromLength(chr); k++)
              for (int y=0; y<64; y++)
                {
                  if (tab.get(j,i).getY())
                    {
                      if ((1ULL<<(63-y))&(tab.get(j,i).h2[k+chr_offset]))
                        sum[y+64*k]++;
                    }
                  else
                    {
                      if ((1ULL<<(63-y))&(tab.get(j,i).h1[k+chr_offset]))
                        sum[y+64*k]++;
                    }
                }
          }
  }
  else
  {
    for (uint i=0; i<tab.getHeight(); ++i)
      for (uint j=0; j<tab.getWidth(); ++j)
        if (tab.isAlive(j,i) && (lat.getPopulation(tab.get(j,i).getPop()).get()==pop) && tab.get(j,i).getGender()==MALE && tab.get(j,i).isFIVETed())
          {
            for (uint k=0; k<pop->getChromLength(chr); k++)
              for (int y=0; y<64; y++)
                {
                  if (tab.get(j,i).getY())
                    {
                      if ((1ULL<<(63-y))&(tab.get(j,i).h2[k+chr_offset]))
                        sum[y+64*k]++;
                    }
                  else
                    {
                      if ((1ULL<<(63-y))&(tab.get(j,i).h1[k+chr_offset]))
                        sum[y+64*k]++;
                    }
                }
          }
  }

  drawChart(out,sum);
}

void TxtChromosome::drawChart(std::ofstream & out, std::vector<uint> sum) const
{
  const uint width=sum.size();
  for (uint i=0; i<width; i++)
    out << sum[i] << std::endl;
}
