/*
 * TxtChromosome.hpp
 *
 *  Created on: 2010-01-22
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef TXTCHROMOSOME_HPP_
#define TXTCHROMOSOME_HPP_

#include <fstream>

#include "../detail/defs.hpp"
#include "Text.hpp"
#include "../Lattice.hpp"

class TxtChromosome : public Text
{
public:
  TxtChromosome(const Lattice &l);
  void write(const std::string & filename) const;
  void write(const std::string & filename, bool f) const;
  void write(const std::string & filename, usint population) const;
  void write(const std::string & filename, usint population, bool f) const;

private:
  void drawSingleChromosomeChart(std::ofstream & out, uint offset, usint chrNum, const Population * pop, bool f) const;
  void drawXChromosomeChart(std::ofstream & out, uint offset, const Population * pop, bool f) const;
  void drawYChromosomeChart(std::ofstream & out, uint offset, const Population * pop, bool f) const;
  void drawChart(std::ofstream & out, std::vector<uint> sum) const;
};

#endif /* TXTCHROMOSOME_HPP_ */
