/*
 * Population.cpp
 *
 *  Created on: 2009-12-30
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include <boost/lexical_cast.hpp>
#include <iostream>
#include "Population.hpp"

Population::Population(std::string n,const std::vector<uchar> & vec, bool hasY):
  name(n),t(1),f(1),c(1),life_span(128),chromosomes(vec),
  mutation_factor(1), fivet_factor(1), recombination_factor(1),
  Y(hasY),panmixia(false),has_fivet_(false),promiscuous(false), ba(50),ra(80),
  altered(true),initType('z'),recombinations_(vec.size()),
  mutations_(vec.size()),mutations_increased_(vec.size()),B_(1),
  infertility_(0), infertilityAF_(0), FIVETefficacy_(0)
{
  num_chunks=0;
  for (uint i=0; i<vec.size(); i++)
    {
      chrom_offsets.push_back(num_chunks);
      num_chunks+=vec[i];
    }
  setMutationRate(0);
  setRecombRate(0);
  setB(0);
}


void Population::init(std::string s)
{
  altered=true;
  if (s.compare(0,4,"rand")==0)
    {
      if (s.length()>=5)
	{
	  const std::string tmp=s.substr(5,s.length()-4);
	  try{
	    initType='r';
	    initVal=boost::lexical_cast<usint>(tmp);
	  } catch(boost::bad_lexical_cast)
	    {
	      std::cerr << "You have specified: " << s << " as an init string." << std::endl;
	      std::cerr << "Proper values include zero rand and rand XXX where XXX is a positive number" << std::endl;
	      exit(1);
	    }
	} else
        {
	  initType='r';
	  initVal=1;
        }
    } else
    if (s.compare("zero")==0)
      initType='z';
    else
      {
	if (s.compare("pair")==0)
	  initType='p';
	else
	  {
            if (s.compare("test")==0)
              initType='t';
            else
              {
                std::cerr << "You have specified: " << s << " as an init string." << std::endl;
                std::cerr << "Proper values include zero rand and rand XXX where XXX is a positive number" << std::endl;
                exit(1);
              }
          }
      }
}

void Population::setRecombRate(float R)
{
  altered=true;
  recombination_rate_list=fvector(getNumChromosomes(),R);
  recombinations_.setLambda(recombination_rate_list,recombination_factor);
}

void Population::setRecombRate(const fvector &val)
{
  altered=true;
  recombination_rate_list=val;
  recombinations_.setLambda(recombination_rate_list,recombination_factor);
}

void Population::setRecombinationFactor(float r)
{
  altered=true;
  recombination_factor=r;
  recombinations_.setLambda(recombination_rate_list,recombination_factor);
}

void Population::setReconMarker(usint chr, usint bit)
{
  if (chr>=chromosomes.size())
    throw NchrException("setReconMarker: Wrong number of chromosome.");
  if (bit>=chromosomes[chr]*64)
    throw NchrException("setReconMarker: Wrong number of bit.");
  recognition_markers.setMarker(chr,bit);
}

void Population::setMutationRate(float M)
{
  altered=true;
  mutation_rate_list=fvector(getNumChromosomes(),M);
  mutations_.setLambda(mutation_rate_list,mutation_factor);
  mutations_increased_.setLambda(mutation_rate_list,mutation_factor*fivet_factor);
}

void Population::setMutationRate(const fvector &val)
{
  altered=true;
  mutation_rate_list=val;
  mutations_.setLambda(mutation_rate_list,mutation_factor);
  mutations_increased_.setLambda(mutation_rate_list,mutation_factor*fivet_factor);
}

void Population::setMutationFactor(float f)
{
  altered=true;
  mutation_factor=f;
  mutations_.setLambda(mutation_rate_list,mutation_factor);
  mutations_increased_.setLambda(mutation_rate_list,mutation_factor*fivet_factor);
}

