#include "ext/tut.hpp"
#include <vector>
#include <memory>
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/serialization/vector.hpp>
#include "detail/auto_ptr_serial.hpp"
#include "Population.hpp"

namespace
{

struct test_struct
{
  test_struct():P1("Nazwa",getSize(1),false),
                P2("Nazwa",getSize(1),true),
                P3("Nazwa",getSize(3),false),
                P4("Nazwa",getSize(3),true)
  {
    P1==P2;
  }

  Population P1,P2,P3,P4;

  const std::vector<uchar> getSize(usint size) const
  {
    std::vector<uchar> v;

    for (uint i=0; i<size; i++)
      v.push_back((rand()%5)*2);
    return v;
  }
};

typedef tut::test_group<test_struct> tf;
typedef tf::object object;
tf tests("Core/Population");
}

namespace tut
{

//Checks default constructor.
template<>
template<>
void object::test<1>()
{
}

//same layout
template<>
template<>
void object::test<2>()
{
  ensure(!P1.sameLayout(&P2));
  ensure(P1.sameLayout(&P1));
  ensure(!P2.sameLayout(&P3));
  ensure(!P2.sameLayout(&P1));
}

//serialization
template<>
template<>
void object::test<3>()
{
  std::vector<uchar> v(2,2);
  std::stringstream s;
  std::auto_ptr<Population> Pa(new Population("Name",v,true));
  std::auto_ptr<Population> Pb;

  {
    boost::archive::text_oarchive oa(s);
    oa << Pa;
  }

  {
    boost::archive::text_iarchive ia(s);
    ia >> Pb;
  }

  ensure((*Pa)==(*Pb));
}

  //TODO
  //initialization


}




