/*
 * PythonAPI.cpp
 *
 *  Created on: 2010-01-03
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include "PopulationAPI.hpp"

void PopulationAPI::setFatherDist(int f_dist)
{
  p->setFatherDist(f_dist);
}

int PopulationAPI::getFatherDist() const
{
  return p->getFatherDist();
}

void PopulationAPI::setChildDist(int c_dist)
{
  p->setChildDist(c_dist);
}

int PopulationAPI::getChildDist() const
{
  return p->getChildDist();
}

void PopulationAPI::setB(float b)
{
  p->setB(b);
}

float PopulationAPI::getB() const
{
  return p->getB();
}

void PopulationAPI::setT(int t)
{
  p->setT(t);
}

int PopulationAPI::getT() const
{
  return p->getT();
}

void PopulationAPI::setBirthAge(int r)
{
  p->setBirthAge(r);
}

int PopulationAPI::getBirthAge()
{
  return p->getBirthAge();
}

void PopulationAPI::setLifeSpan(uint ls)
{
  p->setLifeSpan(ls);
}

void PopulationAPI::setReproductionAge(int r)
{
  p->setReproductionAge(r);
}

int PopulationAPI::getReproductionAge() const
{
  return p->getReproductionAge();
}


void PopulationAPI::setRecombRate(float R)
{
  p->setRecombRate(R);
}

boost::python::list PopulationAPI::getRecombRate() const
{
  return vecToList<float>(p->getRecombRate());
}

void PopulationAPI::setMutationRate(float M)
{
  p->setMutationRate(M);
}

boost::python::list PopulationAPI::getMutationRate() const
{
  return vecToList<float>(p->getMutationRate());
}

void PopulationAPI::setRecombRate(boost::python::list list)
{
  p->setRecombRate(listToVec<float>(list));
}

void PopulationAPI::setRecombinationFactor(float r)
{
  p->setRecombinationFactor(r);
}

void PopulationAPI::setReconMarker(usint chr, usint bit)
{
  p->setReconMarker(chr,bit);
}

void PopulationAPI::setMutationRate(boost::python::list list)
{
  p->setMutationRate(listToVec<float>(list));
}

void PopulationAPI::setMutationFactor(float f)
{
  p->setMutationFactor(f);
}

void PopulationAPI::setFivetFactor(float f)
{
  p->setFivetFactor(f);
}

void PopulationAPI::useFivet(bool b)
{
  p->useFivet(b);
}

void PopulationAPI::initial(const std::string  s)
{
  p->init(s);
}

void PopulationAPI::setFIVETefficacy(float f)
{
  p->setFIVETefficacy(f);
}

void PopulationAPI::setInfertility(float f)
{
  p->setInfertility(f);
}

void PopulationAPI::setInfertilityAF(float f)
{
  p->setInfertilityAF(f);
}
