/*
 * PythonAPI.hpp
 *
 *  Created on: 2010-01-03
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef POPULATIONAPI_HPP_
#define POPULATIONAPI_HPP_

#include <string>
#include <vector>
#include <boost/python.hpp>
#include <boost/python/docstring_options.hpp>

#include "detail/defs.hpp"
#include "Population.hpp"
#include "Lattice.hpp"

#include "FileImg/ImageProperties.hpp"


class PopulationAPI
{
public:
  PopulationAPI(const std::string &n, const boost::python::list &list, bool hasY):
    p(new Population(n,listToVec<uchar>(list), hasY))  {  }

  PopulationAPI(Lattice::PopulationPtr pop):p(pop) {  }


  void setMutationRate(float M);
  void setMutationRate(boost::python::list list);
  boost::python::list getMutationRate() const;

  void setReconMarker(usint chr, usint bit);

  void setRecombinationFactor(float r);
  void setRecombRate(float R);
  void setRecombRate(boost::python::list list);
  boost::python::list getRecombRate() const;


  void setMutationFactor(float f);
  void setFivetFactor(float f);
  void useFivet(bool f);
  void setFIVETefficacy(float f);

  void setInfertility(float f);
  void setInfertilityAF(float f);

  void setFatherDist(int f_dist);
  int getFatherDist() const;

  void setChildDist(int c_dist);
  int getChildDist() const;

  void setB(float b);
  float getB() const;

  void setT(int t);
  int getT() const;

  std::string getName() const
  {
    return p->getName();
  }

  void initial(const std::string s);


  void setBirthAge(int r);
  int getBirthAge();

  bool hasFivet()
  {
    return p->hasFivet();
  }

  void setLifeSpan(uint ls);

  void setReproductionAge(int r);
  int getReproductionAge() const;

  usint getNumChunks() const
  {
    return p->getNumChunks();
  }

  usint getNumChromosomes() const
  {
    return p->getNumChromosomes();
  }

  Lattice::PopulationPtr getP() const
  {
    return p;
  }

  void setPromisc(bool pr)
  {
    p->setPromisc(pr);
  }

private:
  template <class T>
  std::vector<T> listToVec(const boost::python::list &list) const
  {
    const int n = boost::python::extract<int>(list.attr("__len__")());
    std::vector<T> chr;
    for ( int i = 0; i < n; i++ )
      chr.push_back (boost::python::extract<T>((list)[i]));
    return chr;
  }

  template <class T>
  boost::python::list vecToList(const std::vector<T> vec) const
  {
    boost::python::list t;
    for(typename std::vector<T>::const_iterator it=vec.begin(); it!=vec.end(); ++it)
      t.append(*it);
    return t;
  }

private:
  Lattice::PopulationPtr p;
};

#endif /* POPULATIONAPI_HPP_ */

