/*
 * Specimen.cpp
 *
 *  Created on: 2009-12-30
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include <stdexcept>
#include "Specimen.hpp"

Specimen::Specimen():num_chunks(0),h1(0),h2(0),age(0),which_Y(false),population(0),gender(MALE),infertile_(false),FIVETed(false)
{
}

Specimen::Specimen(usint nc, bool rl):num_chunks(nc),h1(0),h2(0),age(0),which_Y(false),population(0),gender(MALE),infertile_(false),FIVETed(false)
{
  if (rl)
    realloc(nc);
}

Specimen::Specimen(const Specimen & ref):num_chunks(ref.num_chunks),age(ref.age),which_Y(ref.which_Y),population(ref.population),gender(ref.gender),infertile_(ref.infertile_),FIVETed(ref.FIVETed)
{
  if (ref.num_chunks)
    {
      h1=new uint64_t[num_chunks];
      h2=new uint64_t[num_chunks];
      for (uint i=0; i<num_chunks; i++)
	{
	  h1[i]=ref.h1[i];
	  h2[i]=ref.h2[i];
	}
    } else
    {
      h1=0;
      h2=0;
    }
}

Specimen& Specimen::operator=(const Specimen& b)
{
  age=b.age;
  gender=b.gender;
  which_Y=b.which_Y;
  num_chunks=b.num_chunks;
  population=b.population;
  infertile_=b.infertile_;
  FIVETed=b.FIVETed;

  delete[] h1;
  delete[] h2;

  if (num_chunks)
    {
      h1=new uint64_t[num_chunks];
      h2=new uint64_t[num_chunks];

      for (uint i=0; i<num_chunks; i++)
        {
          h1[i]=b.h1[i];
          h2[i]=b.h2[i];
        }
    } else
    {
      h1=0;
      h2=0;
    }
  return *this;
}

bool Specimen::operator==(const Specimen& b) const
{
  if (age!=b.age)
    return false;
  if (gender!=b.gender)
    return false;
  if (which_Y!=b.which_Y)
    return false;
  if (num_chunks!=b.num_chunks)
    return false;
  if (population!=b.population)
    return false;
  if (num_chunks!=b.num_chunks)
    return false;
 if (infertile_!=b.infertile_)
    return false;
  if (FIVETed!=b.FIVETed)
    return false;

  for (uint i=0; i<num_chunks; i++)
    if ((h1[i]!=b.h1[i]) || (h2[i]!=b.h2[i]))
      return false;
  return true;
}

Specimen::~Specimen()
{
  delete[] h1;
  delete[] h2;
}

void Specimen::realloc(usint nc)
{
  num_chunks=nc;
  delete[] h1;
  delete[] h2;
  h1=new uint64_t[num_chunks];
  h2=new uint64_t[num_chunks];
}

void Specimen::randomHaplotypes(usint n)
{
  for (uint i=0; i<num_chunks; i++)
    {
      h1[i]=0xffffffffffffffffULL;
      for (usint j=0; j<n; j++)
	h1[i]&=rand64();

      h2[i]=0xffffffffffffffffULL;
      for (usint j=0; j<n; j++)
	h2[i]&=rand64();
    }
}

void Specimen::zeroHaplotypes()
{
  for (uint i=0; i<num_chunks; i++)
    h1[i]=h2[i]=0;
}

void Specimen::testHaplotypes()
{
  for (uint i=0; i<num_chunks; i++)
    h1[i]=h2[i]=0;
  h1[num_chunks-1]=4;
  h2[num_chunks-1]=4;
}


void Specimen::initialize(const Population &p, Gender g)
{
  setAge(rand()%(p.getLifeSpan()-p.getBirthAge())+p.getBirthAge());
  setGender(g);
  realloc(p.getNumChunks());
  setY(rand()%2==0); //TODO: is it still neccesary?

  char initType=p.getInitType();

  if (initType=='z')
    zeroHaplotypes();
  else
    if (initType=='r')
      randomHaplotypes(p.getInitVal());
    else
      if (initType=='t')
        testHaplotypes();

  if (p.hasReconMarkers())
    for (usint i_chr=0,offset=0; i_chr<p.getNumChromosomes(); i_chr++)
      {
        if (p.hasRecognition(i_chr))
          setMarker(p.getMarkerBit(i_chr)+offset*64);
        offset+=p.getChromLength(i_chr);
      }

  if (p.getInfertility()>rand_0to1())
    setInfertile(true);
  else
    setInfertile(false);
  setFIVETed(false);
}

void Specimen::initialize(const Population &p)
{
  initialize(p,Gender(rand()%2==0));
}

