#include "ext/tut.hpp"
#include <vector>
#include <boost/shared_ptr.hpp>

#include "Lattice.hpp"
#include "detail/defs.hpp"

namespace
{

struct test_struct
{
  test_struct():s(2,true)
  {
    s.setGender(FEMALE);
  }

  Specimen s;
};

typedef tut::test_group<test_struct> tf;
typedef tf::object object;
tf tests("Core/Specimen");
}

namespace tut
{

  //constructor
  template<>
  template<>
  void object::test<1>()
  {
  }

  //check operator=
  template<>
  template<>
  void object::test<2>()
  {
    Specimen s3=s;

    ensure(s3.h1[0]==s.h1[0]);
    ensure(s3.h1[1]==s.h1[1]);
    ensure(s3.h2[0]==s.h2[0]);
    ensure(s3.h2[1]==s.h2[1]);

    ensure(s==s3);
  }

  //check operator==
  template<>
  template<>
  void object::test<3>()
  {
    Specimen s3;

    s3=s;
    s3.setGender(MALE);
    ensure(s!=s3);

    s3=s;
    s3.zeroHaplotypes();
    ensure(s!=s3);
  }

  //setmarker
  template<>
  template<>
  void object::test<4>()
  {
    Specimen s1(2,true);
    s1.zeroHaplotypes();

    ensure_equals("Marker 1",s1.h1[0],0ULL);
    ensure_equals("Marker 2",s1.h2[0],0ULL);

    s1.setMarker(2);

    ensure((s.h1[0]|s.h2[0])!=0);
  }
}
