/*
 * SpecimenBit.hpp
 *
 *  Created on: 2009-12-30
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef SPECIMENBIT_HPP_
#define SPECIMENBIT_HPP_

#include <stdint.h>
#include <boost/serialization/access.hpp>
#include <boost/serialization/version.hpp>
#include <boost/operators.hpp>
#include <iostream>

#include "detail/defs.hpp"
#include "detail/NchrException.hpp"
#include <stdexcept>

class SpecimenBit : public Specimen
{
  friend class boost::serialization::access;

  template<class Archive>
  void serialize(Archive & ar, const unsigned int version)
  {
  }
};


BOOST_CLASS_EXPORT(derived);

BOOST_CLASS_VERSION(SpecimenBit, 1)

namespace boost
{
  namespace serialization
  {
    template<class Archive>
    inline void save_construct_data(Archive & ar, const SpecimenBit * t, const unsigned int file_version)
    {
      usint nc=t->getNumChunks();
      ar << nc;
    }

    template<class Archive>
    inline void load_construct_data(Archive & ar, SpecimenBit * t, const unsigned int file_version)
    {
      usint nc;
      ar >> nc;
      ::new(t)SpecimenBit(nc,true);
    }
  }
} // namespace ...

#endif /* SPECIMENBIT_HPP_ */

