/*
 * bench.cpp
 *
 *  Created on: 2010-02-06
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include <fstream>
#include <iostream>
#include <vector>
#include <signal.h>
#include <time.h>
#include <sys/time.h>
#include "detail/defs.hpp"
#include "Population.hpp"
#include "Lattice.hpp"


int main()
{
  struct timeval start, end;
  long mtime, seconds, useconds;

  std::vector<uchar> v;
  v.push_back(4);
  v.push_back(4);

  boost::shared_ptr<Population> P(new Population("P1",v,true));
  P->setB(8);
  P->setBirthAge(50);
  P->setReproductionAge(80);
  P->setRecombRate(0.5);
  P->setMutationRate(1.0);
  P->setChildDist(2);
  P->setFatherDist(2);
  P->setT(1);
  P->init("zero");

  std::cout << "PB\t 128\t  256\t  512" << std::endl;
  for (int t=0; t<=4; t+=2)
    {
      P->setChildDist(t);
      P->setFatherDist(t);
      if (t==0)
        std::cout << "Panm.\t";
      else
        std::cout << t << '\t';

      for (uint i=128; i<=512; i*=2)
	{
	  Lattice L(i,i);
	  L.fill(P);
	  L.setPanmixia(t==0);

	  gettimeofday(&start, NULL);
	  for (uint y=0; y<500; y++)
	    L.nexGen();
	  gettimeofday(&end, NULL);

	  seconds  = end.tv_sec  - start.tv_sec;
	  useconds = end.tv_usec - start.tv_usec;

	  mtime = ((seconds) * 1000 + useconds/1000.0) + 0.5;
	  std::cout << (50000000/(mtime))/100.0 << '\t' <<std::flush;

	}
      std::cout << std::endl;
    }
  return 0;
}
