/*
 * Atab.hpp
 *
 *  Created on: 2009-12-31
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef ATAB_HPP_
#define ATAB_HPP_

#include <memory>

#include "defs.hpp"
#include "Tab.hpp"
#include "../Specimen.hpp"
#include "../Population.hpp"
#include "../Environment.hpp"
#include "PopStatistics.hpp"

class IteratorAtab;
class Lattice;

class Atab
{
public:
  typedef std::pair<float,float> float2;

  Atab(boost::shared_ptr<Population> p);
  Atab(const Atab & ref);
  ~Atab();
  Atab & operator=(const Atab & ref);
  void scroll(Tab &tab,  Lattice  & L);
  bool kill(Tab &tab, usint x, usint y, Gender g, uint age);
  void updateIterators();

  bool isLoser(const Specimen & s, usint x, usint y, usint d_year=0, const Environment * env=NULL) const;
  bool isLoserAbs(const Specimen & s, usint x, usint y, usint year, const Environment * env=NULL) const;
  const Point getFather();

  uint getAtabInd(usint age, Gender g) const;
  Point getGuy(usint age, Gender g, uint pos) const;
  uint getSpecimenCount() const;
  uint getSpecimenCount(bool f) const;

  void atabInsert(usint y, usint x, const Specimen &s);

  typedef std::vector<Point>::iterator iterator;

public:
  const iterator & end()
  {
    if (iterators_invalidated)
      {
        updateIterators();
        iterators_invalidated=false;
      }
    return end_;
  }

  const iterator & begin()
  {
    if (iterators_invalidated)
      {
        updateIterators();
        iterators_invalidated=false;
      }
    return begin_;
  }

  const boost::shared_ptr<Population> &getPopulation() const
  {
    return pop;
  }

  const PopStatistics & getPopStats() const
  {
    return pop_stats;
  }

  void commitStats(const Tab &tab, uint gen) const;

  void statsBirth()
  {
    pop_stats.incrBirth();
  }

  void statsConception()
  {
    pop_stats.incrConception();
  }

  void statsLifeExpectancy(uint year)
  {
    pop_stats.incrLifeExpectancy(year);
  }

  float2 computeFractionofDefects(const Tab &tab, usint chromosme) const;

private:
  Point ***aging_tab;
  uint **atab_ind, **max_atab;
  uint specimen_count;
  uint F_specimen_count;
  uint infertile_male_countBA, infertile_male_countBARA;
  uint infertile_female_countBA, infertile_female_countBARA;
  boost::shared_ptr<Population> pop;
  uint gennum;
  bool iterators_invalidated;
  std::vector<Point> vec; //vector of females
  iterator begin_,end_; //vector of females
  mutable PopStatistics pop_stats;
  std::vector <uint> males_in_reproduction_period;
  uint males_in_reproduction_period_max;
};

#endif /* ATAB_HPP_ */
