#include "../ext/tut.hpp"
#include <vector>
#include <boost/shared_ptr.hpp>

#include "defs.hpp"
#include "Atab.hpp"
#include "../Population.hpp"


namespace
{

struct test_struct
{
  test_struct():s1(1,true),s2(2,true)
  {
    std::vector<uchar> v;
    v.push_back(2);
    P.reset(new Population("P1",v,true));
    P->setBirthAge(50);
    P->setReproductionAge(80);
    P->init("zero");

    s1.zeroHaplotypes();
    s2.zeroHaplotypes();
  }

  Specimen s1;
  Specimen s2;
  boost::shared_ptr<Population> P;
};

typedef tut::test_group<test_struct> tf;
typedef tf::object object;
tf tests("detail/Atab");
}

namespace tut
{

  //isLoser
  template<>
  template<>
  void object::test<1>()
  {
    Atab a(P);

    s1.h1[0]=-1;
    s1.h2[0]=-1;
    s1.setAge(0);

    ensure(a.isLoser(s1,0,0,0,NULL));
  }

  //isLoser 2
  template<>
  template<>
  void object::test<2>()
  {
    Atab a(P);

    s1.h1[0]=1;
    s1.h2[0]=1;
    s1.setAge(63);

    ensure(a.isLoser(s1,0,0,0,NULL));
  }

  //isLoser 3
  template<>
  template<>
  void object::test<3>()
  {
    Atab a(P);

    s1.h1[0]=0;
    s1.h2[0]=0;
    s1.setAge(63);

    ensure(!a.isLoser(s1,0,0,0,NULL));
  }

  //isLoser 4
  template<>
  template<>
  void object::test<4>()
  {
    Atab a(P);

    s2.h1[1]=1;
    s2.h2[1]=1;
    s2.setAge(127);

    ensure(a.isLoser(s2,0,0,0,NULL));
  }

  //isLoser 5
  template<>
  template<>
  void object::test<5>()
  {
    Atab a(P);

    s2.h1[1]=2;
    s2.h2[1]=2;
    s2.setAge(127);

    ensure(a.isLoser(s2,0,0,0,NULL));
  }

  //isLoser 6
  template<>
  template<>
  void object::test<6>()
  {
    Atab a(P);

    s2.h1[1]=0;
    s2.h2[1]=0;
    s2.setAge(125);

    ensure(!a.isLoser(s2,0,0,0,NULL));
  }

}
