/*
 * FemaleRandomizer.hpp
 *
 *  Created on: 2010-01-19
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef FEMALERANDOMIZER_HPP_
#define FEMALERANDOMIZER_HPP_

#include <vector>
#include <assert.h>
#include <iostream>

#include "defs.hpp"
#include "Atab.hpp"

class FemaleRandomizer
{
public:
  FemaleRandomizer(uint s):tab(0),size(s)
  {
    tab=new Point[size];
  }

  ~FemaleRandomizer()
  {
    delete[] tab;
  }

private:
  FemaleRandomizer(const FemaleRandomizer & ref);

public:
  void clear()
  {
    index=0;
  }

  void insert(const Atab::iterator & begin, const Atab::iterator & end)
  {
    for (Atab::iterator it=begin; it!=end; ++it)
      {
        assert(index<size);
        tab[index++]=*it;
      }
  }

  bool isEmpty() const
  {
    return (index==0);
  }

  Point getFemale()
  {
    assert (index>0);
    uint n=rand()%index;
    Point ret=tab[n];
    tab[n]=tab[--index];
    return ret;
  }

private:
  Point * tab;
  uint index,size;
};

#endif /* FEMALERANDOMIZER_HPP_ */
