/*
 * Line.hpp
 *
 *  Created on: 2010-01-03
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef LINE_HPP_
#define LINE_HPP_

#include <boost/serialization/serialization.hpp>

class Line : private boost::equality_comparable<Line>
{
public:
  Line():x_(0),y_(0),w_(0),z_(0){}
  Line(usint x, usint y, usint w, usint z):x_(x),y_(x),w_(w),z_(z){}
  friend class boost::serialization::access;

  template<class Archive>
  void serialize(Archive & ar, const unsigned int version)
  {
    ar & x_;
    ar & y_;
    ar & w_;
    ar & z_;
  }

  bool operator==(const Line & l) const
  {
    if (x_!=l.x_) return false;
    if (y_!=l.y_) return false;
    if (w_!=l.w_) return false;
    if (z_!=l.z_) return false;
    return true;
  }

public:
  usint x_,y_,w_,z_;
};

#endif /* LINE_HPP_ */
