#include "../ext/tut.hpp"
#include <vector>
#include <boost/math/distributions/poisson.hpp>
#include "defs.hpp"
#include "Poisson.hpp"

namespace
{

struct test_struct
{

};

typedef tut::test_group<test_struct> tf;
typedef tf::object object;

tf tests("detail/Poisson");
}

namespace tut
{
  //small single Lambda
  template<>
  template<>
  void object::test<1>()
  {
    Poisson P(1);
    P.setLambda(2);

    double sum=0;
    for (int i=0; i<1000; i++)
      {
        uint a=P.getNum(0);
        ensure(a>=0);
        sum+=a;
      }
    sum/=1000;
    ensure((sum>1.9) && (sum<2.1));
  }

  //big single Lambda
  template<>
  template<>
  void object::test<2>()
  {
    Poisson P(1);
    P.setLambda(207);

    double sum=0;
    for (int i=0; i<1000; i++)
      {
        uint a=P.getNum(0);
        ensure(a>=0);
        sum+=a;
      }
    sum/=1000;
    ensure((sum>206.5) && (sum<207.5));
  }

  //vector of lambdas
  template<>
  template<>
  void object::test<3>()
  {
    std::vector<float> v;
    v.push_back(0.1);
    v.push_back(0.1);
    v.push_back(2.4);
    v.push_back(0.6);
    v.push_back(1.2);
    v.push_back(101);

    Poisson P(6);
    P.setLambda(v);

    std::vector<double> sum(v.size(),0);

    for (uint j=0; j<v.size(); j++)
      for (uint i=0; i<10000; i++)
        {
          uint a=P.getNum(j);
          ensure(a>=0);
          sum[j]+=a;
        }

    for (uint j=0; j<v.size(); j++)
      {
        sum[j]/=10000;
        ensure((sum[j]>(0.9*v[j])) && (sum[j]<(1.1*v[j])));
      }
  }

  //Lambda==0 should work
  template<>
  template<>
  void object::test<4>()
  {
    Poisson P(1);
    P.setLambda(0);

    double sum=0;
    for (int i=0; i<1000; i++)
      {
        uint a=P.getNum(0);
        ensure(a>=0);
        sum+=a;
      }
    ensure(sum==0);
  }

  //operator==
  template<>
  template<>
  void object::test<5>()
  {
    Poisson P1(1),P2(1);
    P1.setLambda(1);
    P2.setLambda(1);
    ensure(P1==P2);
  }

  //copy constructor
  template<>
  template<>
  void object::test<6>()
  {
    Poisson P1(1);
    P1.setLambda(1);
    Poisson P2(P1);
    ensure(P1==P2);
  }

  //operator=
  template<>
  template<>
  void object::test<7>()
  {
    Poisson P1(1);
    P1.setLambda(1);
    Poisson P2(2);
    P2.setLambda(1);
    P2=P1;
    ensure(P1==P2);
  }

  //vector of lambdas
  template<>
  template<>
  void object::test<8>()
  {
    std::vector<float> v;
    v.push_back(0.1);
    v.push_back(0.2);

    Poisson P1(v.size());
    P1.setLambda(v);

    Poisson P2(v.size());
    P2.setLambda(v,3);

    std::vector<double> sum1(v.size(),0);
    std::vector<double> sum2(v.size(),0);

    for (uint j=0; j<v.size(); j++)
      for (uint i=0; i<10000; i++)
        {
          const uint a1=P1.getNum(j);
          const uint a2=P2.getNum(j);
          ensure(a1>=0);
          ensure(a2>=0);
          sum1[j]+=a1;
          sum2[j]+=a2;
        }

    for (uint j=0; j<v.size(); j++)
      ensure((sum2[j]>(2.9*sum1[j])) && (sum2[j]<(3.1*sum1[j])));
  }


}

