/*
 * PopStatistics.cpp
 *
 *  Created on: 2010-02-09
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#include "PopStatistics.hpp"

void PopStatistics::setFractions(const std::vector<std::pair<float,float> > &data)
{
  assert(data.size() == temp.size());
  for (uint i=0; i<temp.size(); i++)
    {
      temp[i].fractionBA=data[i].first;
      temp[i].fractionBARA=data[i].second;
    }
}

void PopStatistics::commit(uint gen)
{
  for (uint i=0; i<chromosomes.size(); ++i)
    {
      chromosomes[i].push_back(temp[i]);
      temp[i].clear();
    }

  non_chr_stats.push_back(temp_non_chr);
  temp_non_chr.clear();
  gennum.push_back(gen);
}
