/*
 * RecognitionMarkers.hpp
 *
 *  Created on: 2010-10-13
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef RECOGNITIONMARKERS_HPP_
#define RECOGNITIONMARKERS_HPP_

#include <boost/operators.hpp> //for equality_comparable
#include <boost/serialization/serialization.hpp>
#include <vector>
#include <cassert>
#include "defs.hpp"

class RecognitionMarkers : private boost::equality_comparable<RecognitionMarkers>
{
public:
  RecognitionMarkers():markercount_(0)
  {
  }

  void setMarker(usint chr, usint bit)
  {
    if (chr>=value_.size())
      {
        isset_.resize(chr+1,false);
        value_.resize(chr+1,0);
      }

    if (!isset_[chr])
      markercount_++;

    isset_[chr]=true;
    value_[chr]=bit;
  }

  bool isSet(usint chr) const
  {
    if(chr>=isset_.size())
      return false;
    return isset_[chr];
  }

  usint getMarker(usint chr) const
  {
    assert(chr<isset_.size());
    return value_[chr];
  }

  void unsetMarker(usint chr)
  {
    assert(chr<isset_.size());
    if (isset_[chr])
      markercount_--;
    isset_[chr]=false;
  }

  bool isEmpty() const
  {
    return (markercount_==0);
  }

  friend class boost::serialization::access;

  /**
   * @brief Serialization for saving and loading files.
   */
  template<class Archive>
  void serialize(Archive & ar, const unsigned int version)
  {
    ar & markercount_;
    ar & isset_;
    ar & value_;
  }

  bool operator==(const RecognitionMarkers & rm) const
  {
    if (markercount_!=rm.markercount_) return false;
    if (isset_!=rm.isset_) return false;
    if (value_!=rm.value_) return false;
    return true;
  }

private:
  usint markercount_;
  std::vector<bool> isset_;
  std::vector<usint> value_;
};


#endif /* RECOGNITIONMARKERS_HPP_ */
