#include "../ext/tut.hpp"
#include <vector>

#include "RecognitionMarkers.hpp"

namespace
{

struct test_struct
{
  RecognitionMarkers R;
};

typedef tut::test_group<test_struct> tf;
typedef tf::object object;
tf tests("detail/RecognitionMarkers");
}

namespace tut
{
  //default c-tor
  template<>
  template<>
  void object::test<1>()
  {
    ensure(R.isEmpty());
    ensure(!R.isSet(0));
    ensure(!R.isSet(1));
  }

  //setMarker
  template<>
  template<>
  void object::test<2>()
  {
    R.setMarker(2,12);
    ensure(!R.isSet(0));
    ensure(!R.isSet(1));
    ensure(R.isSet(2));
    ensure(!R.isSet(3));
  }

  //getMarker
  template<>
  template<>
  void object::test<3>()
  {
    R.setMarker(2,12);
    ensure_equals("getMarker",R.getMarker(2),12U);
  }

  //unsetMarker
  template<>
  template<>
  void object::test<4>()
  {
    R.setMarker(2,12);
    R.setMarker(3,1);

    ensure(!R.isEmpty());
    ensure(R.isSet(2));
    ensure(R.isSet(3));

    R.unsetMarker(2);
    ensure(!R.isEmpty());
    ensure(!R.isSet(2));
    ensure(R.isSet(3));

    R.unsetMarker(3);
    ensure(R.isEmpty());
    ensure(!R.isSet(2));
    ensure(!R.isSet(3));
  }
}
