/*
 * Statistics.hpp
 *
 *  Created on: 2009-12-28
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef STATISTICS_HPP_
#define STATISTICS_HPP_
#include <ostream>
#include <string>
#include <map>

class Statistics
{
public:
  Statistics():on_(false){}

  void setValue(const std::string & key, int64_t value)
  {
    if(on_)
      paramsInt[key]=value;
  }

  void inc(const std::string  & key)
  {
    if(on_)
      paramsInt[key]++;
  }

  void dec(const std::string  & key)
    {
    if(on_)
      paramsInt[key]--;
    }

  int64_t getValueInt(const std::string & key) const
  {
    return paramsInt[key];
  }

  void print(std::ostream & out, const char * file, int line)
    {
      if(on_)
        {
        out << file << ':' << line << ' ';
        for ( std::map<std::string,int64_t>::const_iterator iter = paramsInt.begin(); iter != paramsInt.end(); ++iter )
          out << iter->first << '\t' << iter->second << '\n';
        }
    }

  void print(std::ostream & out)
  {
    if(on_)
    for ( std::map<std::string,int64_t>::const_iterator iter = paramsInt.begin(); iter != paramsInt.end(); ++iter )
      out << iter->first << '\t' << iter->second << '\n';
  }

  void off()
  {
    on_=false;
  }

  void on()
  {
    on_=true;
  }

private:
  bool on_;
  mutable std::map<std::string,int64_t> paramsInt;
};

#endif /* STATISTICS_HPP_ */
