/*
 * Tab.hpp
 *
 *  Created on: 2010-02-10
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef TAB_HPP_
#define TAB_HPP_

#include <vector>
#include "defs.hpp"
#include "../Specimen.hpp"


class Tab
{
  typedef std::vector<bool>  vecB;
  typedef std::vector<vecB> vecBB;

public:
  Tab(usint w, usint h):
    tab_(h,vectSp(w)),
    alive_(h,vecB(w,false)),
    width_(w),height_(h)
  {}

  Specimen & get(Point p)
  {
    return get(p.first,p.second);
  }

  const Specimen & get(Point p) const
  {
    return tab_[p.second][p.first];
  }

  Specimen & get(usint x, usint y)
  {
    return tab_[y][x];
  }

  const Specimen & get(usint x, usint y) const
  {
    return tab_[y][x];
  }

  bool isAlive(Point p) const
  {
    return isAlive(p.first,p.second);
  }

  bool isAlive(usint x, usint y) const
  {
    return alive_[y][x];
  }

  void setAlive(Point p, bool a)
  {
    setAlive(p.first,p.second,a);
  }

  void setAlive(usint x, usint y, bool a)
  {
    alive_[y][x]=a;
  }

  usint getHeight() const
  {
    return height_;
  }

  usint getWidth() const
  {
    return width_;
  }

  friend class boost::serialization::access;

  template<class Archive>
  void serialize(Archive & ar, const unsigned int version)
  {
    ar & tab_;
    ar & alive_;
  }

  bool operator==(const Tab & t2) const
  {
    if (width_!=t2.width_ || height_!=t2.height_)
      return false;
    if (alive_!=t2.alive_)
      return false;
    if (tab_!=t2.tab_)
      return false;
    return true;
  }

private:
  vectSpSp tab_;
  vecBB alive_;
  usint width_,height_;
};


BOOST_CLASS_VERSION(Tab,3)

namespace boost
{
  namespace serialization
  {
    template<class Archive>
    inline void save_construct_data(Archive & ar, const Tab * t, const unsigned int file_version)
    {
      usint width=t->getWidth(); //dirty, lousy workaround of ambiguity with friend declaration. Sorry.
      usint height=t->getHeight();
      ar << width;
      ar << height;
    }

    template<class Archive>
    inline void load_construct_data(Archive & ar, Tab * t, const unsigned int file_version)
    {
      usint width,height;
      ar >> width;
      ar >> height;
      ::new(t)Tab(width,height);
    }
  }
} // namespace ...

#endif /* TAB_HPP_ */
