#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/serialization/vector.hpp>
#include "auto_ptr_serial.hpp"

#include "../ext/tut.hpp"

#include "Tab.hpp"

namespace
{

struct test_struct
{
  test_struct():T(64,32)
  {
  }

  Tab T;
};

typedef tut::test_group<test_struct> tf;
typedef tf::object object;
tf tests("detail/Tab");
}

namespace tut
{
  //c-tor
  template<>
  template<>
  void object::test<1>()
  {
    ensure_equals("getWidth",T.getWidth(),64U);
    ensure_equals("getHeight",T.getHeight(),32U);
  }

  //isAlive
  template<>
  template<>
  void object::test<2>()
  {
    for (uint i=0; i<64; i++)
      for (uint j=0; j<32; j++)
        ensure(!T.isAlive(i,j));
  }

  //serialization
  template<>
  template<>
  void object::test<3>()
  {
    std::stringstream s;
    std::auto_ptr<Tab> Ta(new Tab(32,16));
    std::auto_ptr<Tab> Tb;

    {
      boost::archive::text_oarchive oa(s);
      oa << Ta;
    }

    {
      boost::archive::text_iarchive ia(s);
      ia >> Tb;
    }
    ensure((*Ta)==(*Tb));
  }
}
