/*
 * auto_ptr_serial.hpp
 *
 *  Created on: 2009-12-22
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef AUTO_PTR_SERIAL_HPP_
#define AUTO_PTR_SERIAL_HPP_

#include <memory>
#include <boost/serialization/split_free.hpp>

namespace boost {
namespace serialization {
  template<class Archive, class T>

  inline void save(Archive & ar, const std::auto_ptr<T> &t, const unsigned int file_version)
  {
    // only the raw pointer has to be saved
    // the ref count is rebuilt automatically on load
    const T * const tx = t.get();
    ar << tx;
  }

  template<class Archive, class T>

  inline void load(Archive & ar, std::auto_ptr<T> &t, const unsigned int file_version)
  {
    T *pTarget;
    ar >> pTarget;
    // note that the reset automagically maintains the reference count
#if BOOST_WORKAROUND(BOOST_DINKUMWARE_STDLIB, == 1)
    t.release();
    t = std::auto_ptr<T>(pTarget);
#else
    t.reset(pTarget);
#endif
  }
  // split non-intrusive serialization function member into separate
  // non intrusive save/load member functions
  template<class Archive, class T>

  inline void serialize(Archive & ar, std::auto_ptr<T> &t, const unsigned int file_version)
  {
    boost::serialization::split_free(ar, t, file_version);
  }
} // namespace serialization
} // namespace boost

#endif /* AUTO_PTR_SERIAL_HPP_ */
