/*
 * defs.hpp
 *
 *  Created on: 2009-12-30
 *      Author: Wojciech Waga <wojciech.waga.com>
 */

#ifndef DEFS_HPP_
#define DEFS_HPP_

#include <cstdlib>
#include <cassert>
#include <stdint.h>
#include <vector>
#include <cmath>
#include "Statistics.hpp"

typedef unsigned char uchar;
typedef unsigned int musint;
typedef unsigned short int usint;
typedef unsigned int uint;

typedef std::pair<usint, usint> Point;

typedef std::vector<int> ivector;
typedef std::vector<uint> uivector;
typedef std::vector<float> fvector;
typedef std::vector<std::pair<uint, float> > ifvector;

typedef ivector::iterator ivectorIt;
typedef fvector::iterator fvectorIt;

#include <iostream>

enum Gender {MALE=0, FEMALE=1, INF_MALE=2, INF_FEMALE=3, FIVETed_MALE=4, FIVETed_FEMALE=5};


//Mask64 (0) -  0x0000000000000000L
//Mask64 (1) -  0x0000000000000001L
//Mask64 (63) -  0x7fffffffffffffffL
//Mask64 (64) -  0xffffffffffffffffL

class Mask64
{
public:
  Mask64()
  {
    tab[0]=0;
    tab[1]=1;
    for (int j=2; j<65; j++)
      tab[j]=(tab[j-1]<<1)|1;
  }

  uint64_t operator()(uchar pos)
  {
    assert(pos<65);
    return tab[pos];
  }
private:
  uint64_t tab[65];
};

extern Mask64 mask64;

void print_binary(uint64_t);

inline uint64_t rand64()
{
  __uint64_t hi,lo;
  lo=rand();
  hi=rand();
  hi<<=32;
  hi+=lo;
  if (rand()%2==0)  hi|=0x8000000000000000ULL;
  if (rand()%2==0)  hi|=0x0000000080000000ULL;
  return hi;
}

inline float rand_0to1()
{
  return (float(rand())/RAND_MAX);
}

inline uchar bit_count64(uint64_t n)
{
  uchar c;
  for (c = 0; n; c++)
    n &= n - 1; // clear the least significant bit set
  return c;
}

inline uint64_t getBit(uchar bitnum)
{
  assert(bitnum<64);
  return (0x1ULL<<(63-bitnum));
}

//constant epsilon is sufficient here
inline bool compareDouble(double a, double b)
{
  return fabs(a-b)<0.0000001;
}

inline bool compareFloatVec(const fvector & a, const fvector & b)
{
  if (a.size()!=b.size())
    return false;
  for (fvector::const_iterator ita=a.begin(), itb=b.begin(); ita!=a.end(); ++ita, ++itb)
    if (fabs(*ita-*itb)>0.0000001) return false;
  return true;
}


extern Statistics stats;

extern uint sig_caught;

#endif /* DEFS_HPP_ */
