#include "../ext/tut.hpp"
#include <vector>

#include "defs.hpp"

namespace
{

struct test_struct
{
  Mask64 mask;
};

typedef tut::test_group<test_struct> tf;
typedef tf::object object;
tf tests("detail/defs");
}

namespace tut
{

  //mask64
  template<>
  template<>
  void object::test<1>()
  {
    ensure_equals("Mask64(0)",mask(0),0ULL);
    ensure_equals("Mask64(1)",mask(1),1ULL);
    ensure_equals("Mask64(2)",mask(2),3ULL);
    ensure_equals("Mask64(63)",mask(63),0x7fffffffffffffffULL);
    ensure_equals("Mask64(64)",mask(64),0xffffffffffffffffULL);
  }

  //bit_count64
  template<>
  template<>
  void object::test<2>()
  {
    ensure_equals("bit_count 1",static_cast<uint>(bit_count64(0x7fffffffffffffffULL)),63U);
    ensure_equals("bit_count 2",static_cast<uint>(bit_count64(0xffffffffffffffffULL)),64U);
    ensure_equals("bit_count 3",static_cast<uint>(bit_count64(0x7fffffff0ffff0ffULL)),55U);
    ensure_equals("bit_count 4",static_cast<uint>(bit_count64(0x7000000000000000ULL)),3U);
    ensure_equals("bit_count 5",static_cast<uint>(bit_count64(0x1ULL)),1U);
    ensure_equals("bit_count 6",static_cast<uint>(bit_count64(0x0ULL)),0U);
  }

  //mask bitcount
  template<>
  template<>
  void object::test<3>()
  {
    ensure_equals("bitcount mask 0",static_cast<uint>(bit_count64(mask(0))),0U);
    ensure_equals("bitcount mask 12",static_cast<uint>(bit_count64(mask(12))),12U);
    ensure_equals("bitcount mask 45",static_cast<uint>(bit_count64(mask(45))),45U);
    ensure_equals("bitcount mask 64",static_cast<uint>(bit_count64(mask(64))),64U);

  }

  //rand_0to1
  template<>
  template<>
  void object::test<4>()
  {
    for (uint i=0; i<100000; i++)
      {
	float f=rand_0to1();
	ensure(f>=0 && f<=1);
      }
  }

  //getBit
  template<>
  template<>
  void object::test<5>()
  {
    ensure_equals("getBit(63)",getBit(63),1ULL);
    ensure_equals("getBit(50)",getBit(50),8192ULL);
    ensure_equals("getBit(20)",getBit(20),8796093022208ULL);
    ensure_equals("getBit(1)",getBit(1),4611686018427387904ULL);
    ensure_equals("getBit(0)",getBit(0),9223372036854775808ULL);
  }

  //rand64
  template<>
  template<>
  void object::test<6>()
  {
    std::vector<uint> v(64,0);
    for (uint i=0; i<20000; i++)
      {
	const uint64_t num=rand64();
	for (uint bit=0; bit<64; bit++)
	  if (num&getBit(bit))
	    v[bit]++;
      }
    for (uint bit=0; bit<64; bit++)
      ensure(v[bit]>0.9*10000 && v[bit]<1.1*10000);
  }

}
